-- DROP FUNCTION sp_apply_local_repo_binding (VARCHAR, VARCHAR);
CREATE OR REPLACE FUNCTION sp_apply_local_repo_binding (VARCHAR, VARCHAR)
RETURNS INTEGER AS $$
DECLARE
    local_repos ALIAS FOR $1;
    devices ALIAS FOR $2;
    invalid_scope INTEGER;
    is_all_in_one INTEGER;

BEGIN
  SELECT COUNT(*)
  FROM tb_system_settings
  WHERE key='server_mode' AND value='ALL'
  INTO is_all_in_one;
  RAISE NOTICE 'is_all_in_one: %', is_all_in_one;

IF is_all_in_one = 1 THEN

  SELECT CASE
      WHEN EXISTS
             ( SELECT *
              FROM unnest(string_to_array(devices, ' ')) AS g, tb_tree_node AS t
              WHERE (t.guid = g
                     AND t.type_ <> 2)
                OR (t.guid = g
                    AND (t.product_type IS NULL
                         OR t.product_type=31105)) -- DEVICE must NOT be LR. LR: 31105
             ) THEN 1
           ELSE 0
  END INTO invalid_scope;

  IF invalid_scope <> 0 THEN
    return invalid_scope;
  END IF;

  DELETE FROM tb_local_repo_device_binding
  WHERE device_guid IN
      (SELECT dev
       FROM unnest(string_to_array(devices, ' ')) dev
       );  -- remove original binging

  INSERT INTO tb_local_repo_device_binding (device_guid, local_repo_guid, priority)

  SELECT a.device_guid, s.guid, 1
  FROM ( SELECT device_guid
        FROM unnest(string_to_array(devices, ' ')) AS device_guid
        INNER JOIN tb_tree_node t
        ON (t.guid = device_guid AND t.type_ = 2)
        ) a
  INNER JOIN tb_system_node s
  ON (s.type_=1);
  return 0;

END IF;

SELECT CASE
    WHEN EXISTS
           (SELECT product_type
            FROM unnest(string_to_array(devices, ' ')) AS g
            LEFT OUTER JOIN tb_tree_node AS t
            ON (g = t.guid)
            WHERE product_type IS NULL OR product_type=31105
            ) THEN 2 -- device not existed or a LR
    WHEN local_repos = ''
          THEN 0  -- All devices existed when NO LR specified. Reset LR bidning
    WHEN EXISTS
           ( SELECT *
            FROM unnest(string_to_array(local_repos, ' ')) AS g, tb_tree_node AS t
            WHERE (t.guid = g
                   AND t.product_type <> 31105)
           ) THEN 3  -- local-repo must be LR. LR: 31105
    WHEN NOT EXISTS
           ( SELECT *
            FROM unnest(string_to_array(local_repos, ' ')) AS g, tb_tree_node AS t
            WHERE (t.guid = g
                   AND t.product_type = 31105)
           ) THEN 4  -- local-repo must be LR and existed. LR: 31105
    ELSE 0
END INTO invalid_scope;

RAISE NOTICE 'invalid_scope: %', invalid_scope;

IF invalid_scope = 0 THEN
    DELETE FROM tb_local_repo_device_binding
    WHERE device_guid IN
        (SELECT dev
         FROM unnest(string_to_array(devices, ' ')) dev
         );

    RAISE NOTICE 'local_repos: %', local_repos;

    INSERT INTO tb_local_repo_device_binding (device_guid, local_repo_guid, priority)
    SELECT dev_guid,
           r.local_guid,
           r.priority
    FROM
      (SELECT d.dev_guid
       FROM unnest(string_to_array(devices, ' ')) AS d(dev_guid)
       INNER JOIN tb_tree_node t
       ON (t.guid = d.dev_guid)
       ) as dev_guid ,
      (SELECT row_number() over () AS priority,
              local_guid
       FROM
         (SELECT local.local_guid
          FROM unnest(string_to_array(local_repos, ' ')) AS local(local_guid)) a) r
      ;

END IF;

return invalid_scope;

END;

$$ LANGUAGE plpgsql;
